<?php
session_start();
include("config.php");
include('funciones.php');
validacion_usuario($con);
include('include/head.php');
?>
<body>
<?php include("include/menu.php") ?> 
	<div class="container margin-top">
		<div class="panel panel-info">
		    <div class="panel-heading">
		      <h3 class="panel-title">Nuevo Banner</h3>
		    </div>
		    <div class="panel-body">
	      		<form id="formulario_bannernuevo" name="formulario" method="post" enctype="multipart/form-data" action="bannernue_grabar.php">			
		        	<div class="row">
		        		<div class="col-sm-2">
		        			<a type="button" href="banner.php" class="btn btn-primary">Ver lista de Banner</a>
		        			<br><br>
		        		</div>
		        	</div>	
		        	<div class="row"><div class="col-sm-12"><div class="alert alert-warning"> Se permiten imágenes de formato .jpg, .png</div></div></div>			
		          <div class="row"><div class="col-sm-12"><label for="imagen">Imágen Web</label></div></div>
		          <div class="row"><div class="col-sm-12"><div class="alert alert-warning">La imágen web debe tener un tamaño de 1365 x 438 px. La imágen debe tener un tamaño menor o igual a 120 kb.</div></div></div>
		          <div class="row"><div class="col-sm-12"><input name="imagen_escritorio" type="file" id="imagen_escritorio" size="88" maxlength="170" /></div></div>
					    <br>		        
		          <div class="row"><div class="col-sm-12"><label for="imagen">Imágen Mobile</label></div><div class="col-sm-12"><div class="alert alert-warning">La imágen mobile debe tener un tamaño de 880 x 524 px. La imágen debe tener un tamaño menor o igual a 120 kb.</div></div></div>
		          <div class="row"><div class="col-sm-12"><input name="imagen_mobile" type="file" id="imagen_mobile" size="88" maxlength="170" /></div></div>
					    <br>
             <div class="row"><div class="col-sm-12"><label for="imagen">Link</label></div></div>
					   <div class="row"><div class="col-sm-12"><input name="link" class="form-control" type="text" id="link" size="88" maxlength="170" /></div></div>		 	 
					   <br> 
					   <div class="row"> 
						   <div class="col-sm-12">
						 	   <textarea class="custom_ckeditor" name="cuerpo_interno" id="cuerpo_interno" rows="10" cols="80">				              
				        </textarea>
						    </div>
					    </div>		 	
					    <br>  					
    					<div class="row">
    						<div class="col-sm-12"> 
    							<a class="btn btn-default" href="banner.php" role="button">Regresar</a>
    					         <input class="submit btn btn-default" id="submitBtn" type="submit" value="Grabar">
    					    </div>    		               
    					</div>	                 
				</form>
				<div id="imgContainer_escritorionuevo"></div>
        <div id="imgContainer_mobilenuevo"></div>   				
			</div>
		</div>
	</div>
</div>	
		
<script src="js/jqueryvalidation/jquery.js"></script>    
<script type="text/javascript" src="js/ckeditor/function_ckeditor.min.js"></script>
<?php include("include/footer.php");?>
<script type="text/javascript" src="js/validation.js"></script>
<?php
      include("include/ckeditor.php");
?>
<script src="js/jqueryvalidation/jquery.validate.min.js"></script>
<script src="js/jqueryvalidation/additional-methods.js"></script>   
<script>
jQuery(document).ready(function($){
$('#formulario_bannernuevo').validate({
              rules: {                
                cuerpo_interno:{
                  cke_required:false
                },
                link: {                   
                      required: true,
                      url: true
                },
                imagen_escritorio: {                    
                  required: true,
                  extension: "jpg,jpeg,png",                      
                  callbackbannernuevo: {
                   callback_bannernuevo: function() {
                     return $imagen_escritorio.data('imageWidth')  == 1365 && $imagen_escritorio.data('imageHeight')  == 438;
                    }
                  },
                  filesize:{
                        size:120000,
                        kb:120,
                  }   
                },
                  imagen_mobile: {                    
                      required: true,
                      extension: "jpg,jpeg,png",
                      callbackbannermobile: {                        
                           callback_bannermobile: function() {
                              return $imagen_mobile.data('imageWidth')  == 880 && $imagen_mobile.data('imageHeight') == 524;
                          }                  
                      },   
                      filesize:{
                      size:120000,
                      kb:120,
                     }                  
                  }
              },
                errorPlacement: function( error, element ) {                  
                    error.insertBefore(element);                
          },
               messages: {
              imagen_escritorio: {
                required: "Este campo es requerido",
                callbackbannernuevo: "La imágen de cabecera debe tener un tamaño mínimo de 1365px y 438px."
              },
              imagen_mobile: {
                required: "Este campo es requerido",
                callbackbannermobile: "La imágen de cabecera debe tener un tamaño mínimo de 880px y 524px."
              },
          }
        
          });

    var  $submitBtn = $('#submitBtn'),$imagen_escritorio = $('#imagen_escritorio'),
    $imagen_mobile = $('#imagen_mobile'),
    $imgContainer_escritorio_nuevo = $('#imgContainer_escritorionuevo'),
    $imgContainer_mobile_nuevo = $('#imgContainer_mobilenuevo');
    
    $('#imagen_escritorio').change(function() {
      var fileName = $(this).val(); 
      $submitBtn.attr('disabled', true);
      $imgContainer_escritorio_nuevo.hide().empty();
      $imagen_escritorio.removeData('imageWidth');
      $imagen_escritorio.removeData('imageHeight');
       
      var file = this.files[0];
      if(fileName != ""){
       if (file.type.match(/image\/.*/)) {
          var reader = new FileReader();
          reader.onload = function() {
          var $img = $('<img />').attr({ src: reader.result });
         $imgContainer_escritorio_nuevo.append($img).show();
          $img.on('load', function() {
          var imageWidth = $img.width();
          var imageHeight= $img.height();   
          $imagen_escritorio.data('imageWidth', imageWidth);
          $imagen_escritorio.data('imageHeight', imageHeight);
              if (imageWidth != 1365 && imageHeight  != 438) {
                $imgContainer_escritorio_nuevo.hide();
              }
              $submitBtn.attr('disabled', false);
              $("img").addClass("img-responsive");
               $imgContainer_escritorio_nuevo.hide();
            });
          }
          reader.readAsDataURL(file);
        }
       }
    });

    $('#imagen_mobile').change(function() {
       var fileName = $(this).val(); 
      $submitBtn.attr('disabled', true);
      $imgContainer_mobile_nuevo.hide().empty();
      $imagen_mobile.removeData('imageWidth');
      $imagen_mobile.removeData('imageHeight');

      var file = this.files[0];
     if(fileName != ""){
       if (file.type.match(/image\/.*/)) {
          var reader = new FileReader();
          reader.onload = function() {
          var $img = $('<img />').attr({ src: reader.result });
         $imgContainer_mobile_nuevo.append($img).show();
          $img.on('load', function() {
          var imageWidth = $img.width();
          var imageHeight= $img.height();   
          $imagen_mobile.data('imageWidth', imageWidth);
          $imagen_mobile.data('imageHeight', imageHeight);
              if (imageWidth != 880 && imageHeight  != 524) {
                $imgContainer_mobile_nuevo.hide();
              }
              $submitBtn.attr('disabled', false);

              $("img").addClass("img-responsive");
               $imgContainer_mobile_nuevo.hide();
            });
          }
          reader.readAsDataURL(file);
        }
       }
    });
})
</script>
</body>
</html> 	