<?php
/**
 * innovapucptheme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package innovapucptheme
 * @subpackage innovapucptheme
 * @since innovapucptheme
 */



function dmc_add_svg_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'dmc_add_svg_mime_types');



/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as
  indicating support for post thumbnails.
 */
add_action( 'after_setup_theme', 'yourtheme_setup' );
 
function yourtheme_setup() {
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );
}

/** 
 * Filer WooCommerce Flexslider options - Add Navigation Arrows
 */
function sf_update_woo_flexslider_options( $options ) {

    $options['directionNav'] = true;

    return $options;
}


function innovapucptheme_setup() {

	load_theme_textdomain( 'innovapucptheme' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );

	add_image_size( 'customtheme-featured-image', 2000, 1200, true );

	add_image_size( 'customtheme-thumbnail-avatar', 100, 100, true );
	add_image_size( 'customtheme-featured-image_v2', 1200, 1200, true );
	$GLOBALS['content_width'] = 525;

	register_nav_menus( array(
		'top'    => __( 'Top Menu', 'innovapucptheme' ),
		'social' => __( 'Social Links Menu', 'innovapucptheme' ),
    'social' => __( 'Social Links Menu', 'innovapucptheme' ),
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'       => 250,
		'height'      => 250,
		'flex-width'  => true,
	) );

	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );

	remove_action( 'wp_print_styles', 'print_emoji_styles' ); 
}
add_action( 'after_setup_theme', 'innovapucptheme_setup' );

function customtheme_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'innovapucptheme' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'innovapucptheme' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
  
}
add_action( 'widgets_init', 'customtheme_widgets_init' );




function customtheme_scripts() {
wp_deregister_script('jquery');
  
  //estilos
	 wp_enqueue_style( 'innovapucptheme', get_stylesheet_uri() );
	 wp_enqueue_style( 'open-bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css', array(), 'v1.0.0', 'all' );
   wp_enqueue_style( 'open-css-a', get_template_directory_uri() . '/css/style.css', array(), 'v1.0.1', 'all' );
   wp_enqueue_style( 'open-css-b', get_template_directory_uri() . '/css/owl.carousel.min.css', array(), 'v1.0.0', 'all' );
   wp_enqueue_style( 'open-css-c', get_template_directory_uri() . '/css/owl.theme.default.min.css', array(), 'v1.0.0', 'all' );
  //javascript
  wp_register_script( 'jquery-a', 'https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js' , false, NULL, true);
  wp_register_script( 'jquery-b', 'https://code.jquery.com/jquery-3.6.0.min.js' , false, NULL, true);
  wp_register_script( 'jquery-c', get_template_directory_uri() .'/js/owl.carousel.min.js' , false, NULL, true);
 
     
wp_enqueue_script('jquery-a');
wp_enqueue_script('jquery-b');
wp_enqueue_script('jquery-c');


	
}
add_action( 'wp_enqueue_scripts', 'customtheme_scripts' );
add_filter( 'widget_text', 'do_shortcode' );



//  WOOCOMMERCE CONFIGURATION

function mytheme_add_woocommerce_support() {
  add_theme_support( 'woocommerce' );
}

/**
 * Register Custom Navigation Walker
 */
function register_navwalker(){
  require_once get_template_directory() . '/class-wp-bootstrap-navwalker.php';
}
add_action( 'after_setup_theme', 'register_navwalker' );
function add_style_select_buttons( $buttons ) {
    array_unshift( $buttons, 'styleselect' );
    return $buttons;
}
// Register our callback to the appropriate filter
add_filter( 'mce_buttons_2', 'add_style_select_buttons' );

//add custom styles to the WordPress editor
function my_custom_styles( $init_array ) {  

    $style_formats = array(  
        // These are the custom styles
        array(  
            'title' => 'Banner Título',  
            'block' => 'span',  
            'classes' => 'banner__titulo',
            'wrapper' => true,
        ),  
        array(  
            'title' => 'Presentación azul',  
            'block' => 'span',  
            'classes' => 'presentacion presentacion--azul',
            'wrapper' => true,
        ),
        array(  
            'title' => 'Presentación Plomo',  
            'block' => 'span',  
            'classes' => 'presentacion presentacion--plomo',
            'wrapper' => true,
        ),
        array(  
            'title' => 'Opinión',  
            'block' => 'span',  
            'classes' => 'slide-comen__opinion',
            'wrapper' => true,
        ),
        array(  
            'title' => 'Explicación Servicios',  
            'block' => 'span',  
            'classes' => 'd-block servicio__explicacion',
            'wrapper' => true,
        ),
        

       
    );  
    // Insert the array, JSON ENCODED, into 'style_formats'
    $init_array['style_formats'] = json_encode( $style_formats );  
    
    return $init_array;  
  
} 
// Attach callback to 'tiny_mce_before_init' 
add_filter( 'tiny_mce_before_init', 'my_custom_styles' );


function composer(){
 
  /* Start the Loop */
  //while ( have_posts() ) : the_post();

    if( have_rows('agregar_herramienta') ):
          while( have_rows('agregar_herramienta') ) : the_row();
        //inicia switch
              switch (get_sub_field('elige_tu_modulo')) {
                case '1':{
                  if( have_rows('main_slider') ):
                    $j=0;
                    echo '<section><div id="carouselHome" class="carousel slide" data-bs-ride="carousel"><div class="carousel-inner">';
                    while( have_rows('main_slider') ) : the_row(); ?>
                    <div class="carousel-item <?php if($j==0){ echo 'active'; } ?>">
                         <?php if(get_sub_field('tipo_de_item')==1){  ?>
                            <video class="videoHome"  playsinline="playsinline" autoplay="autoplay" muted="false" loop="loop" preload="">  
                              <source src="<?php echo get_sub_field('video'); ?>" type="video/mp4" codecs="avc1.4D401E, mp4a.40.2">
                                <p>Su navegador no soporta la etiqueta de vídeo.</p>
                            </video>
                            <img class="carouselHome__figura" src="<?php echo get_template_directory_uri(); ?>/img/formas-01.png" />
                          <?php } ?>
                          <?php if(get_sub_field('tipo_de_item')==2){ ?>
                                 <img src="<?php echo get_sub_field('imagen_movil'); ?>" class="d-block d-sm-none w-100" alt="...">  
                                 <img src="<?php echo get_sub_field('imagen'); ?>" class="d-none d-sm-block w-100" alt="...">
                            <?php } ?>
                          <div class="carousel-caption">
                            <?php if(get_sub_field('descripcion')!=""){ 
                                echo get_sub_field('descripcion');
                             } ?> 
                            <?php if(get_sub_field('activar_linea_azul')){  ?><div class="banner__linea" ></div> <?php } ?>                           
                            <?php if(get_sub_field('label_del_boton')!=""){ ?>
                            <div class="text-end text-sm-start">
                                <a class="boton boton--transparente" href="<?php echo get_sub_field('url_de_boton'); ?>">
                                    <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/boton-01.png" alt=""> <?php echo get_sub_field('label_del_boton'); ?>
                                </a>
                            </div>
                           <?php } ?>
                          </div>
                        </div>
                <?php $j++; endwhile; 
                    echo '</div>';                    
                       $count = count(get_sub_field('main_slider'));                      
                           $i=0;
                      if($count!=0){
                        echo '<div class="carousel-indicators">'; 
                  for ($i = 0; $i < $count; $i++) {
                    ?>
                   <button type="button" data-bs-target="#carouselHome" data-bs-slide-to="<?php echo $i; ?>" class="<?php if($i==0){ echo 'active'; } ?>" <?php if($i==0){ echo 'aria-current="true"'; } ?> aria-label="Slide <?php echo $i; ?>"></button>
                    <?php
                  }
                    echo '</div>';  
                  }
                  ?>          
                      </div>
                  </section>
              <?php         
                endif;      

                }break;
                case '2':{
                  if( have_rows('main_seccion_texto__beneficios') ):
                    while( have_rows('main_seccion_texto__beneficios') ) : the_row(); ?>
                    <section class="section-y">
                  <div class="container">     
                    <div class="row">
                      <div class="col-sm-7  col-lg-8">
                        <?php echo get_sub_field('texto'); ?>
                      </div>
                          <div class="col-sm-5 col-lg-4">
                          <?php 
                              if( have_rows('beneficios') ):
                              while( have_rows('beneficios') ) : the_row(); ?>
                                <div class="beneficios">
                                  <div class="beneficios__cantidad">
                                    <?php echo get_sub_field('cantidad'); ?>
                                  </div>
                                  <p class="beneficios__explicacion">
                                  <?php echo get_sub_field('explicacion'); ?>
                                 </p>
                              </div>  
                              <?php 
                                endwhile;
                              endif;   
                              ?>  

                      </div>
                    </div>
                    </div>  
                    <div class="capaCeleste"></div> 
                  </section>
                    <?php
                      endwhile;
                    endif;   
                }break;
                case '3':{ 
                  if( have_rows('main_seccion_noticia') ):
                    echo '<div class="d-flex flex-column flex-column flex-md-row">';
                    while( have_rows('main_seccion_noticia') ) : the_row(); ?>
                      
                  <a class="noticia" style="background: url(<?php echo get_sub_field('imagen'); ?>) no-repeat; background-size: cover; " href="<?php echo get_sub_field('url'); ?>">
                    
                        <div class="noticia__fecha"><?php echo get_sub_field('fecha'); ?></div>
                        <div class="noticia__titulo"><?php echo get_sub_field('titulo'); ?></div>
                        
                   </a>

                    

                <?php 
                  endwhile;
                  echo '</div>';
                    endif;    
                }break;
                case '4':{
                  if( have_rows('testimonios') ): $i=0;?>
                      <section class="section-y">
                      <div id="carouselExampleControls" class="carousel slide" data-bs-ride="carousel">
                          <div class="carousel-inner">

                  <?php   while( have_rows('testimonios') ) : the_row();
                  ?>
                    
                            <div class="carousel-item <?php if($i==0){echo 'active'; } ?>">
                              <div class="slide-comen container">
                                  <div class="row">
                                      <div class="col-md-4 text-end  order-last order-md-first mt-2 mt-md-0">
                                          <img class="slide-comen__foto" src="<?php echo get_sub_field('foto'); ?>"/><br>                        
                                          <span class="slide-comen__nombre"><?php echo get_sub_field('nombre'); ?></span><br>
                                          <span class="slide-comen__profesion"><?php echo get_sub_field('profesion'); ?></span>                        
                                      </div>
                                      <div class="col-md-8 d-flex align-items-end order-first order-md-last">
                                          <p class="slide-comen__opinion">
                                            <?php echo get_sub_field('opinion'); ?>
                                          </p>
                                      </div>
                                  </div>

                                  <img src ="<?php echo get_template_directory_uri(); ?>/img/comillas.png"class="slide-comen__comillas" />
                              </div>
                          </div>
                          

                 <?php  
                 $i++;
                 endwhile; ?>
                  </div>
                          <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev">
                          <span class="carousel-control-prev-icon" aria-hidden="true"><img src="<?php echo get_template_directory_uri(); ?>/img/boton-02.png" /></span>
                          <span class="visually-hidden">Previous</span>
                          </button>
                          <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next">
                          <span class="carousel-control-next-icon" aria-hidden="true"><img src="<?php echo get_template_directory_uri(); ?>/img/boton-03.png" /></span>
                          <span class="visually-hidden">Next</span>
                          </button>
                        </div>
                  </section>
                  <br><br>
                <?php  
                endif;
                }break;
                case '5':{
                  if( have_rows('modulo_de_servicios') ): ?>

                       <div class="owl-carousel owl-theme">
                    <?php while( have_rows('modulo_de_servicios') ) : the_row();
                  ?>

                       
                        <a href="<?php echo get_sub_field('url'); ?>" class="item servicio" style="background: url(<?php echo get_template_directory_uri(); ?>/img/formas-carrusel-01.png) no-repeat; background-size: cover; ">            
                            <div class="servicio__detalles" >
                              <div class="servicio__titulo"><?php echo get_sub_field('titulo'); ?></div>
                              <?php echo get_sub_field('explicacion'); ?>
                            </div>

                             <div class="servicio__capa" style="background: url(<?php echo get_template_directory_uri(); ?>/img/carrusel-foto.png) no-repeat; background-size: cover; ">  
                              <div class="servicio__detalles">
                                <div class="servicio__titulo"><?php echo get_sub_field('titulo'); ?></div>
                                <?php echo get_sub_field('explicacion'); ?>
                              </div>
                             </div>
                        </a>
              <?php
                      endwhile;?>


                        <div class="owl-dots"></div>
                  </div>
                    <br>
                  <?php endif;        
                }break;
                case '6':{
                    if( have_rows('banner_bannerinterno') ): ?>  
                    <?php while( have_rows('banner_bannerinterno') ) : the_row();
                      $banner_interna=get_sub_field('banner_interna');
                  ?>
                    <div class="banner <?php if($banner_interna){ echo 'banner--interna'; }?>" style="background: url( <?php echo get_sub_field('imagen'); ?>) no-repeat; background-size: cover; height:500px">
                      <div class="banner__detalle">
                        <h1 class="banner__titulo"> <span class="d-block"> <?php echo get_sub_field('titulo'); ?></span></h1>
                      </div>
                    </div>
                <?php 
                    endwhile;?>

                  <?php endif;  
              }break;

                case '7':{
                  if( have_rows('modulo_presentacion') ): ?>   
                    <?php while( have_rows('modulo_presentacion') ) : the_row();
                      $banner_interna=get_sub_field('presentacion_interna');
                      $h1=' <h1 class="presentacion presentacion--plomo">'.get_sub_field('texto2').'</h1>';
                      $p=' <p class="presentacion presentacion--plomo presentacion--small presentacion--internas mt-5 " >'.get_sub_field('texto2').'</p>';
                  ?>
                    

                  <section class="section-y">
                        <div class="container text-center"> 
                            <h1 class="presentacion presentacion--azul"><?php echo get_sub_field('texto1'); ?> </h1>
                            <?php 
                                if($banner_interna){
                                  echo $p;
                                }
                                else{
                                  echo $h1;
                                }
                            ?>  
                            
                        </div>
                    </section>

              <?php 
                    endwhile;?>

                  <?php endif;
                }break;
                case '8':{
                  if( have_rows('modulo_2_bloques') ): 
                    echo ' <section>
                          <div class="row g-0">';
                         
                    ?>   
                    <?php while( have_rows('modulo_2_bloques') ) : the_row();
                         $estilo=get_sub_field('estilo_bloque');
                      switch ($estilo) {
                        case 'a':{
                          ?>
                          <div class="col-sm-6">
                                   <div class="profesional" style="background: url(<?php echo get_sub_field('foto'); ?>) no-repeat; background-size: cover; ">
                                      <div class="profesional__nombre"><?php echo get_sub_field('texto_izquierdo'); ?></div>
                                  </div>
                              </div>
                              <div class="col-sm-6 compromiso">
                                  <h3 class="compromiso__titulo"><?php echo get_sub_field('titulo_derecho'); ?></h3>
                                  <p class="compromiso__contenido"><?php echo get_sub_field('texto_derecho'); ?> </p>
                              </div>

                        <?php } break;
                        case 'b':{ 
                          ?>
                          <div class="col-sm-6 caracteristicas caracteristicas--azulclaro">
                                    <div class="row">
                                        <div class="col-xl-4">
                                            <div class="caracteristicas__cantidad"><?php echo get_sub_field('cantidad_izquierda'); ?> </div>
                                        </div>
                                        <div class="col-xl-8">
                                            <p class="caracteristicas__texto"><?php echo get_sub_field('texto_izquierdo'); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 caracteristicas caracteristicas--azul">
                                    <div class="row">
                                        <div class="col-xl-4">
                                            <div class="caracteristicas__cantidad"><?php echo get_sub_field('cantidad_derecha'); ?></div>
                                        </div>
                                        <div class="col-xl-8">
                                             <p class="caracteristicas__texto"><?php echo get_sub_field('texto_derecho'); ?></p>
                                        </div>
                                    </div>
                                </div>

                        <?php } break;
                        case 'c':{ ?>
                            <div class="col-md-6 compromiso">
                                    <h1 class="compromiso__titulo"><?php echo get_sub_field('titulo_izquierdo'); ?></h1>
                                    <p class="compromiso__contenido"><?php echo get_sub_field('texto_izquierdo'); ?></p>
                                </div>


                                <div class="col-md-6">
                                     <div class="compromiso h-100" style="background: url(<?php echo get_sub_field('foto'); ?>) no-repeat; background-size: cover; ">
                                        <br><br><br>
                                       <h3 class="compromiso__titulo"><?php echo get_sub_field('titulo_derecho'); ?></h3>
                                        <p class="compromiso__contenido"><?php echo get_sub_field('texto_derecho'); ?></p>
                                    </div>
                                </div>
                        <?php } break;
                        
                      }
                  ?>
                    

                

                  <?php 
                    endwhile;
                    echo '  </div>
                      </section>';
                  endif;
                }break;
                case '9':{
                  if( have_rows('modulo_3_columnas_fondo_celeste') ): 
                     while( have_rows('modulo_3_columnas_fondo_celeste') ) : the_row();

                 ?>

                       <section class="section-y">
                      <div class="container">
                          <h2 class="titulo"> <?php echo get_sub_field('titulo_principal') ?></h2>
                          <div class="row">
                            <?php 
                              if( have_rows('agregar_fila') ): 
                               while( have_rows('agregar_fila') ) : the_row();
                            ?>
                              <div class="col-sm-6">
                                  <p class="principios__titulo"><?php echo get_sub_field('titulo1'); ?></p>
                                  <p class="principios__contenido"><?php echo get_sub_field('texto1'); ?></p>
                              </div>
                              <div class="col-sm-3">
                                 <p class="principios__titulo"><?php echo get_sub_field('titulo2'); ?></p>
                                  <p class="principios__contenido"><?php echo get_sub_field('texto2'); ?></p>
                              </div>

                               <div class="col-sm-3">
                                  <p class="principios__titulo"><?php echo get_sub_field('titulo3'); ?></p>
                                  <p class="principios__contenido"><?php echo get_sub_field('texto3'); ?></p>
                              </div>
                              <?php 
                              endwhile;
                             endif; 
                            ?>
                          </div>
                      </div>
                      <div class="capaCeleste"></div>
                  </section>

                <?php 
                    endwhile;
                  endif;
              }break;
              case '10' : {
                if( have_rows('modulo_nuestro_equipo') ): 
                     while( have_rows('modulo_nuestro_equipo') ) : the_row();
                ?>
                   <section class="section-y">
                      <h2 class="titulo text-center"><?php echo get_sub_field('titulo_principal'); ?></h2>
                      <div class="row g-0">
                        <?php 

                        if( have_rows('agregar_profesional') ): 
                             while( have_rows('agregar_profesional') ) : the_row();
                              ?>

                               <div class="col-sm-3">
                                      <div class="profesional" style="background: url(<?php echo get_sub_field('foto'); ?>) no-repeat; background-size: cover; ">
                                          <div class="profesional__nombre"><?php echo get_sub_field('nombre'); ?></div>
                                          <div class="profesional__cargo"><?php echo get_sub_field('cargo'); ?></div>
                                      </div>
                                  </div>

                             <?php endwhile;
                            endif;        
                        ?>


                         

                      </div>
                  </section>

              <?php
                  endwhile;
                  endif;
               } break;
              case '11' : { 
                  if( have_rows('modulo_equipo_docentes') ): 
                     while( have_rows('modulo_equipo_docentes') ) : the_row();
                     ?>

                     <section class="section-y">
                      <h2 class="titulo text-center"> <?php echo get_sub_field('titulo_principal'); ?></h2>
                      <div class="row docentes g-0">

                      <?php
                          if( have_rows('agregar_docente') ): 
                           while( have_rows('agregar_docente') ) : the_row();
                      ?>  
                          <div class="col-12 col-sm-6 col-md-6 col-lg-3">
                              <div class="card" >
                                <img src="<?php echo get_sub_field('foto'); ?>" class="card-img-top" alt="...">
                                <div class="card-body">
                                  <div class="docente__titulo"><?php echo get_sub_field('nombre'); ?></div>
                                  <div class="docente__cargo"><?php echo get_sub_field('cargo'); ?></div>
                                </div>
                              </div>

                          </div>

                          <?php 
                              endwhile;
                          endif;
                          ?>

                      </div>
                  </section>


              <?php
                endwhile;
              endif;
               } break;
               case '12' : {
                if( have_rows('módulo_fondo_titulo_texto') ): 
                           while( have_rows('módulo_fondo_titulo_texto') ) : the_row();
                ?>
                 <section>
                    <div class="compromisoIntroduccion" style="background: url(<?php echo get_sub_field('fondo'); ?>) no-repeat; background-size: cover;">
                        <div class="container">
                            <h2 class="titulo titulo--blanco"> <?php echo get_sub_field('titulo_principal'); ?></h2>
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="compromisoIntroduccion__texto"><?php echo get_sub_field('texto'); ?></p>

                                </div>
                            </div>
                        </div>
                    </div>    
                </section>  

               <?php
                endwhile;
            endif;
            }break;

            case '13' : {
                if( have_rows('modulo_acordeon') ): 
                           while( have_rows('modulo_acordeon') ) : the_row();

                ?>
                <section class="section-y">        
            <div class="container">
                <h2 class="titulo text-center"><?php echo get_sub_field('titulo_principal'); ?></h2>

                <div class="row">
                    <div class="col-lg-6">
                        <div class="accordion" id="accordionExample">
                        <?php
                        if( have_rows('agregar_acordeon_izquierda') ): 
                          $i=0;
                           while( have_rows('agregar_acordeon_izquierda') ) : the_row();
                          
                         ?>
                        
                           <div class="accordion-item">
                            <h2 class="accordion-header" id="heading_<?php echo $i; ?>">
                              <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse_<?php echo $i; ?>">
                                <img class="accordeon__icono" src="<?php echo get_template_directory_uri(); ?>/img/icono-01.png" alt="" > <?php echo get_sub_field('titulo'); ?>
                              </button>
                            </h2>
                            <div id="collapse_<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i==0){ echo 'show'; } ?> " aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#accordionExample">
                              <div class="accordion-body accordeon__contenido">
                                <ul class="accordeon__lista">
                                   <?php echo get_sub_field('items'); ?>
                                </ul>
                              </div>
                            </div>
                          </div>

                        <?php
                        $i++;
                            endwhile;
                          endif;
                         ?> 
                            
                         
                        
                        </div>
                    </div>

                     <div class="col-lg-6">
                        <div class="accordion" id="accordeonServicios">
                           <?php
                        if( have_rows('agregar_acordeon_derecha') ): 
                          $k=0;
                           while( have_rows('agregar_acordeon_derecha') ) : the_row();
                          
                         ?>
                        
                           <div class="accordion-item">
                            <h2 class="accordion-header" id="heading_<?php echo $k; ?>">
                              <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#accordeonServicios_<?php echo $k; ?>" aria-expanded="true" aria-controls="collapse_<?php echo $k; ?>">
                                <img class="accordeon__icono" src="<?php echo get_template_directory_uri(); ?>/img/icono-01.png" alt="" > <?php echo get_sub_field('titulo'); ?>
                              </button>
                            </h2>
                            <div id="accordeonServicios_<?php echo $k; ?>" class="accordion-collapse collapse <?php if($k==0){ echo 'show'; } ?> " aria-labelledby="heading<?php echo $k; ?>" data-bs-parent="#accordeonServicios">
                              <div class="accordion-body accordeon__contenido">
                                <ul class="accordeon__lista">
                                   <?php echo get_sub_field('items'); ?>
                                </ul>
                              </div>
                            </div>
                          </div>

                        <?php
                        $k++;
                            endwhile;
                          endif;  
                         ?> 
                     
                        </div>
                    </div>
                </div>
            </div>    
        </section>
  
            
            <?php 
            endwhile;
            endif;    
            }break;
            case '14' : {
              if(have_rows('modulo_caracteristica')):
                echo ' <section>
            <div class="row g-0">';

                while(have_rows('modulo_caracteristica')): the_row();?>

                    <div class=" col-md-6 col-xl-3 caracteristicas caracteristicas--<?php echo get_sub_field('color_fondo'); ?>">
                                           <h3 class="compromiso__titulo"> <?php echo get_sub_field('titulo'); ?></h3>
                                          <p class="compromiso__contenido"> <?php echo get_sub_field('texto'); ?> </p>
                   </div>

                 <?php endwhile;
                echo '</div></section>'; 
              endif; 

            }break;
             case '15' : {
              if(have_rows('modulo_iconos_texto_4_columnas')):
                while(have_rows('modulo_iconos_texto_4_columnas')): the_row();?>

                     <section class="section-y">
                          <div class="container text-center"> 
                              <h2 class="presentacion presentacion--azul"><?php echo get_sub_field('titulo_principal'); ?></h2>

                              <p class="presentacion--letra presentacion--plomo2 mt-5"> <?php echo get_sub_field('descripcion'); ?> </p>
                          </div>
                      </section>

                  <?php 
                    if(have_rows('agregar_columna')):
                      echo ' <section >
                                  <div class="container text-center"> 
                                      <div class="row"> ';
                      while (have_rows('agregar_columna')): the_row();
                          ?>
                               <div class="col-md-6 col-xl-3">
                                    <img class="img-fluid mb-3" src="<?php echo get_sub_field('icono'); ?>" alt="">

                                    <h3 class="compromiso__titulo compromiso__titulo--celeste"><?php echo get_sub_field('titulo'); ?> </h3>

                                    <p class="caracteristicas__texto--gris"><?php echo get_sub_field('texto'); ?></p>
                                  </div>

                       <?php endwhile;

                        echo '<div></div></section>';
                       endif;

                   endwhile;
              endif; 

            }break;
            case '16' : {
                if( have_rows('modulo_enlaces_2_columnas') ): 
                           while( have_rows('modulo_enlaces_2_columnas') ) : the_row();

                ?>
             <section>
         <div class="container">
            <h2 class="tituloBold mb-5 text-center"><?php echo get_sub_field('titulo_principal'); ?></h2>
            <div class="row">
               <div class="col-12 col-md-6">
                  <ul class="listaLaboratorios">
                        
                        <?php
                        if( have_rows('agregar_enlaces_izquierda') ): 
                          
                           while( have_rows('agregar_enlaces_izquierda') ) : the_row();
                          
                         ?>
                        
                          <li><a href="<?php echo get_sub_field('url'); ?>"><?php echo get_sub_field('titulo'); ?></a></li>

                        <?php
                        
                            endwhile;
                          endif;
                         ?> 
                            
                         
                       </ul>
                   </div>

                    <div class="col-12 col-md-6">
                         <ul class="listaLaboratorios" >
                           <?php
                        if( have_rows('agregar_enlaces_derecha') ): 
                          
                           while( have_rows('agregar_enlaces_derecha') ) : the_row();
                          
                         ?>
                        
                          <li><a href="<?php echo get_sub_field('url'); ?>"><?php echo get_sub_field('titulo'); ?></a></li>

                        <?php
                       
                            endwhile;
                          endif;
                         ?> 
                        </ul>
               </div>
            </div>
         </div>
      </section>
  
            
            <?php 
            endwhile;
            endif;    
            }break;

            case '17':{
              if(have_rows('modulo_laboratorio_seccion_inicial')):
                while (have_rows('modulo_laboratorio_seccion_inicial')) : the_row();
                    ?>
                       <section class="section-lab-a">
                           <div class="container">
                              <h1 class="titularBold"><?php echo get_sub_field('titulo'); ?></h1>
                           </div>
                           <div class="container">
                              <p class="cabecera_laboratorios"><?php echo get_sub_field('texto1'); ?></p>
                              <div class="descripcion_laboratorios">
                                <?php echo get_sub_field('texto2'); ?>
                              </div>
                           </div>
                        </section>
                        <?php 
                           if(get_sub_field('elegir_multimedia')==1){
                          ?>
                          <section>
                             <div class="slideLaboratorio__container">
                             <div  class="slideLaboratorio" >
                                <iframe width='100%' height='600' src='<?php echo get_sub_field('video'); ?>' frameborder='0' webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
                              </div>
                             </div>
                            </section>  
                          <?php 
                        }
                        if(get_sub_field('elegir_multimedia')==2){ 

                            $count = count(get_sub_field('slider'));
                                if(have_rows('slider')):
                                  ?>
                           <section>
                             <div class="slideLaboratorio__container">
                                            <div id="carouselExampleIndicators" class="slideLaboratorio carousel slide " data-bs-ride="carousel">
                                              <?php  if($count!=0){
                                                      echo '<div class="carousel-indicators">'; 
                                                    for ($i = 0; $i < $count; $i++) {?>
                                               
                                                  <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="<?php echo $i; ?>" class="<?php if($i==0){ echo 'active'; } ?>" <?php if($i==0){ echo 'aria-current="true"'; } ?> aria-label="Slide <?php echo $i; ?>"></button>
                                                 <?php }
                                                 } ?> 
                                               </div>
                                                 <div class="carousel-inner">
                                                <?php
                                                $i=0; 
                                                while (have_rows('slider')) : the_row();
                                                    ?>  
                                                    <div class="carousel-item <?php if($i==0){ echo 'active';} ?>">
                                                       <img src="<?php echo get_sub_field('slide_img'); ?>" class="d-block w-100" alt="...">
                                                    </div>
                                                    

                                                  <?php
                                                  $i++;       
                                                endwhile;

                                                ?>
                                                  </div>
                                             <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                                             <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                             <span class="visually-hidden">Previous</span>
                                             </button>
                                             <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
                                             <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                             <span class="visually-hidden">Next</span>
                                             </button>
                                      </div>
                                     <div class="slideLaboratorio__cuadrado"></div>
                                       
                                    </section>
                                 <?php endif;   
                               

                        } // fin del if slider

                    
                endwhile;
               endif;   

            }break;
            case '18':{
              if(have_rows('modulo_beneficio_laboratorio')):
                while (have_rows('modulo_beneficio_laboratorio')): the_row();

                    ?>
                          <section class="beneficiosLaboratorio section-y">
                             <div class="container">
                                <h2 class="beneficiosLaboratorio__titulo"><?php echo get_sub_field('titulo'); ?></h2>

                                <?php 
                                  if(have_rows('agregar_lista_beneficio')):
                                    while (have_rows('agregar_lista_beneficio')): the_row();
                                ?>
                                 <p class="beneficiosLaboratorio__subtitulo"><?php echo get_sub_field('nombre_beneficio'); ?></p>
                                <div class="row">
                                   <div class="col-12 col-sm-6">
                                      <ul class="beneficiosLaboratorio__lista">
                                        <?php echo get_sub_field('texto_col_izquierda'); ?>
                                      </ul>
                                   </div>
                                   <div class="col-12 col-sm-6">
                                      <ul class="beneficiosLaboratorio__lista">
                                          <?php echo get_sub_field('texto_col_derecha'); ?>
                                      </ul>
                                   </div>
                                </div>
                                  <?php 
                                      endwhile;
                                    endif;
                                    ?>


                                <p class="beneficiosLaboratorio__direccion">
                                    <?php echo get_sub_field('direccion'); ?>
                                </p>
                             </div>
                          </section>

                    <?php 


                endwhile;
               endif;   
              ?>

               

              <?php 
              } break; //fin case 18

              }

          //termina switch           
          endwhile;

           // No value.
          else :
          echo "<h2>No hay contenido</h2>";
         endif;        

        //endwhile; // End of the loop.
}